#!/usr/bin/env python3

import socket
import requests
import concurrent.futures

def domain_ipre_alakitas(domain):
    try:
        eredmeny = socket.getaddrinfo(domain, None, socket.AF_INET6)
        if eredmeny:
            return eredmeny[0][4][0]
    except socket.gaierror:
        pass

    try:
        return socket.gethostbyname(domain)
    except socket.gaierror:
        print("Hiba: A domain feloldása sikertelen.")
        return None

def ip_informacio_lekerese(ip):
    try:
        valasz = requests.get(f"https://ipinfo.io/{ip}/json")
        return valasz.json()
    except requests.RequestException:
        print("Hiba: Az IP információk lekérése sikertelen.")
        return None

def portszkenneles(cel, portok):
    print(f"\nPortszkennelés folyamatban a(z) {cel} címen...")
    nyitott_portok = []

    def port_ellenorzese(port):
        try:
            with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
                s.settimeout(1)
                eredmeny = s.connect_ex((cel, port))
                if eredmeny == 0:
                    nyitott_portok.append(port)
                    print(f"A {port} port nyitva van")
        except Exception:
            pass

    with concurrent.futures.ThreadPoolExecutor(max_workers=100) as executor:
        executor.map(port_ellenorzese, portok)

    return nyitott_portok

def subdomain_kereses(domain):
    print(f"\nSubdomain keresés folyamatban a(z) {domain} domainhez...")
    talalt_subdomainek = []

    try:
        valasz = requests.get(f"https://api.subdomain.center/?domain={domain}")
        subdomainek = valasz.json()

        for subdomain in subdomainek:
            try:
                ip = socket.gethostbyname(subdomain)
                talalt_subdomainek.append(subdomain)
                print(f"Talált: {subdomain} -> {ip}")
            except socket.gaierror:
                pass

    except requests.RequestException:
        print("Hiba: Az API nem elérhető")
    except Exception as e:
        print(f"Hiba: {str(e)}")

    return talalt_subdomainek

def main():
    print("Válassz műveletet:")
    print("1. Domain -> IP átalakítás és IP információk")
    print("2. Portszkennelés")
    print("3. Subdomain keresés")

    valasztas = input("Add meg a választásod (1-3): ")

    if valasztas not in ['1', '2', '3']:
        print("Érvénytelen választás!")
        return

    cel = input("Add meg a domain nevet vagy IP címet: ")

    if valasztas == '1':
        ip = domain_ipre_alakitas(cel)
        if ip:
            print(f"\nFeloldott IP-cím: {ip}")
            info = ip_informacio_lekerese(ip)
            if info:
                print("\nIP információk:")
                for kulcs, ertek in info.items():
                    print(f"{kulcs}: {ertek}")

    elif valasztas == '2':
        port_bemenet = input("Add meg a portokat (pl. '80-100' vagy '22 80 443'): ")
        if '-' in port_bemenet:
            kezdo, vegso = map(int, port_bemenet.split('-'))
            portok = range(kezdo, vegso + 1)
        else:
            portok = list(map(int, port_bemenet.split()))

        ip = domain_ipre_alakitas(cel) if not cel.replace('.', '').isdigit() else cel
        if ip:
            nyitott = portszkenneles(ip, portok)
            print(f"\nSzkennelés kész. Nyitott portok: {nyitott}")

    elif valasztas == '3':
        talaltak = subdomain_kereses(cel)
        print(f"\nKeresés kész. Talált subdomainek: {len(talaltak)} db")

if __name__ == "__main__":
    main()